PipeManager = class()

function PipeManager:created(pipeWidth, pipeSpace, pipeGapSpace, heightRange, pipeVelocity, timeOffset)
    -- you can accept and set parameters here
    self.pipes = {}
    self.timeOffset = timeOffset
    self.startTime = timeOffset
    self.heightRange = heightRange
    self.pipeSpace = pipeSpace
    self.pipeGapSpace = pipeGapSpace
    self.pipeVelocity = pipeVelocity
    self.pipeWidth = pipeWidth
    self.manager = scene.main:findEntity("Manager"):get(GameManager)
    self.firstTime = 0
    self.floor = scene.main:findEntity("Floor"):get(Floor)
end

function PipeManager:update()
    if  self.manager.gameOver then
        for k, pipeGroup in ipairs(self.pipes) do
            pipeGroup.body2d.linearVelocity = vec2(0,0)
            for k1, pipe in ipairs(pipeGroup.children) do
                pipe.collider2d.sensor = true
            end
        end
        self.startTime = time.elapsed + self.timeOffset
    elseif self.manager.startGame then
        if self.startTime + self.firstTime < time.elapsed + self.firstTime then
            local xEgde = scene.main.camera:get(camera).orthoSize * ((WIDTH + 0.0) /HEIGHT)
            
            if #self.pipes == 0 or (self.pipes[#self.pipes].x <= xEgde/2. - self.pipeSpace + (self.pipeWidth / 2.0)) then
                local pipeGroup = scene.main:entity("Pipe Group")
                pipeGroup:add(physics2d.body, DYNAMIC)
                pipeGroup:add(CheckPass, self.pipeWidth)
                local offset = (math.random() * self.heightRange * 2.) - self.heightRange
                pipeGroup.position = vec3(xEgde / 2. + self.pipeWidth / 2., (self.floor.yLine / 2.) + offset, 0)
                pipeGroup.body2d.linearVelocity = vec2(-self.pipeVelocity, 0) 
                
                local pipeHeight = 10000
                local pipeTop = pipeGroup:child("top")
                pipeTop:add(physics2d.body, KINEMATIC)
                pipeTop:add(Pipe, self.pipeWidth, pipeHeight)
                pipeTop.y = pipeHeight /2. + self.pipeGapSpace / 2.
                
                local pipeBottom = pipeGroup:child("bottom")
                pipeBottom:add(physics2d.body, KINEMATIC)
                pipeBottom:add(Pipe, self.pipeWidth, pipeHeight)
                pipeBottom.y = -pipeHeight /2. - self.pipeGapSpace / 2.
                
                table.insert(self.pipes, pipeGroup)
            end
            
            if self.pipes[1].x <= -xEgde/2. - (self.pipeWidth / 2.0) then
                self.pipes[1]:destroy(0)
                table.remove(self.pipes, 1)
            end
            
        end
    else
        self.startTime = time.elapsed + self.timeOffset
    end
    
    if self.manager.isRestarting then
        for k, pipeGroup in ipairs(self.pipes) do
            for k1, pipe in ipairs(pipeGroup.children) do
                pipe:get(Pipe):playDestory()
            end
            pipeGroup:destroy(0.33)
            self.pipes[k] = nil
        end
    end
end
